/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271c;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8271c.BoxInfo;
import ibm.nways.jdm8271c.NlsConstants;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResPairDelete
implements JDMWizardPanelDelegate {
    private static final int RASID = 19;
    private static final int RASSUB = 10;
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    GenModel model;
    GenModel portsModel;
    BoxInfo boxinfo;
    Integer Vlan;
    Integer Unit;
    Integer Port;

    public ResPairDelete() {
        String string = "constructor";
        if (RAS.isEnabled(19, 10)) {
            RAS.enter(19, 10, this, string);
        }
    }

    protected void finalize() {
        String string = "finalize";
        if (RAS.isEnabled(19, 10)) {
            RAS.enter(19, 10, this, string);
        }
    }

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        jDMWizardInfo.getModel();
        ModelInfo modelInfo = jDMWizardInfo.getCurrentRow();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (modelInfo != null) {
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, this, string, "Current Row " + modelInfo.toString());
            }
            this.Vlan = (Integer)modelInfo.get("Panel.ResRepeater");
            this.Unit = (Integer)modelInfo.get("Panel.ResMainSlot");
            this.Port = (Integer)modelInfo.get("Panel.ResMainPort");
            hashtable.put("deleteVlanId", this.Vlan);
            hashtable.put("deleteMainSlot", this.Unit);
            hashtable.put("deleteMainPort", this.Port);
            hashtable.put("deleteStandbySlot", modelInfo.get("Panel.ResStandbySlot"));
            hashtable.put("deleteStandbyPort", modelInfo.get("Panel.ResStandbyPort"));
            hashtable.put("deletego", new Boolean(true));
            this.displayMsg(ResPairDelete.getNLSString("RL_deleteConfirm"));
            return;
        }
        hashtable.put("deleteVlanId", " ");
        hashtable.put("deleteMainSlot", " ");
        hashtable.put("deleteMainPort", " ");
        hashtable.put("deleteStandbySlot", " ");
        hashtable.put("deleteStandbyPort", " ");
        hashtable.put("deletego", new Boolean(false));
        this.displayMsg(ResPairDelete.getNLSString("RL_NodeleteConfirm"));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        String string = "abort";
        if (RAS.isEnabled(19, 10)) {
            RAS.enter(19, 10, this, string);
        }
        this.displayMsg(ResPairDelete.getNLSString("RL_deleteAbort"));
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = false;
        String string = "proceed";
        GenModel genModel = jDMWizardInfo.getModel();
        ModelInfo modelInfo = null;
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (RAS.isEnabled(19, 10)) {
            RAS.trace(19, 10, this, string, "WizardItems = " + hashtable.toString());
        }
        boolean bl2 = (Boolean)hashtable.get("deletego");
        int n = 1;
        while (n <= 3 && bl2) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.ResRepeater", this.Vlan);
            modelInfo.add("Index.ResMainSlot", this.Unit);
            modelInfo.add("Index.ResMainPort", this.Port);
            switch (n) {
                case 1: {
                    modelInfo.add("Panel.ResPairModificationStatus", new Integer(1));
                    break;
                }
                case 2: {
                    modelInfo.add("Panel.ResPairAction", new Integer(2));
                    break;
                }
                case 3: {
                    modelInfo.add("Panel.ResPairModificationStatus", new Integer(2));
                    break;
                }
            }
            try {
                if (RAS.isEnabled(19, 10)) {
                    RAS.trace(19, 10, this, string, "Before Set Number " + n + " ModelInfo = " + modelInfo.toString());
                }
                modelInfo = genModel.setInfo("Panel", modelInfo);
                if (RAS.isEnabled(19, 10)) {
                    RAS.trace(19, 10, this, string, "Set Number " + n + " ModelInfo = " + modelInfo.toString());
                }
                Enumeration enumeration = modelInfo.getItemIds();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Serializable serializable = modelInfo.get(string2);
                    if (!(serializable instanceof SpecialValue)) continue;
                    bl2 = false;
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl2 = false;
                RAS.logException(19, 10, this, string, exception);
            }
            ++n;
        }
        if (bl2) {
            this.displayMsg(ResPairDelete.getNLSString("RL_deleteOK"));
        } else {
            if (RAS.isEnabled(19, 10)) {
                RAS.trace(19, 10, this, string, "Delete failed");
            }
            this.displayMsg(ResPairDelete.getNLSString("RL_deleteError"));
            MessageBox messageBox = new MessageBox(this.browser.getFrame(), ResPairDelete.getNLSString("RL_error"), ResPairDelete.getNLSString("RL_deleteError"), true);
        }
        return bl2;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = NlsConstants.my8271cBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

